// |reftest| skip -- regexp-unicode-property-escapes is not supported
// Copyright 2019 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `Script_Extensions=Bengali`
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v12.0.0
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes]
includes: [regExpUtils.js]
---*/

const matchSymbols = buildString({
  loneCodePoints: [
    0x0009B2,
    0x0009D7,
    0x001CD0,
    0x001CD2,
    0x001CD8,
    0x001CE1,
    0x001CEA,
    0x001CED,
    0x001CF2,
    0x00A8F1
  ],
  ranges: [
    [0x000951, 0x000952],
    [0x000964, 0x000965],
    [0x000980, 0x000983],
    [0x000985, 0x00098C],
    [0x00098F, 0x000990],
    [0x000993, 0x0009A8],
    [0x0009AA, 0x0009B0],
    [0x0009B6, 0x0009B9],
    [0x0009BC, 0x0009C4],
    [0x0009C7, 0x0009C8],
    [0x0009CB, 0x0009CE],
    [0x0009DC, 0x0009DD],
    [0x0009DF, 0x0009E3],
    [0x0009E6, 0x0009FE],
    [0x001CD5, 0x001CD6],
    [0x001CF5, 0x001CF7]
  ]
});
testPropertyEscapes(
  /^\p{Script_Extensions=Bengali}+$/u,
  matchSymbols,
  "\\p{Script_Extensions=Bengali}"
);
testPropertyEscapes(
  /^\p{Script_Extensions=Beng}+$/u,
  matchSymbols,
  "\\p{Script_Extensions=Beng}"
);
testPropertyEscapes(
  /^\p{scx=Bengali}+$/u,
  matchSymbols,
  "\\p{scx=Bengali}"
);
testPropertyEscapes(
  /^\p{scx=Beng}+$/u,
  matchSymbols,
  "\\p{scx=Beng}"
);

const nonMatchSymbols = buildString({
  loneCodePoints: [
    0x000984,
    0x0009A9,
    0x0009B1,
    0x0009DE,
    0x001CD1,
    0x001CD7
  ],
  ranges: [
    [0x00DC00, 0x00DFFF],
    [0x000000, 0x000950],
    [0x000953, 0x000963],
    [0x000966, 0x00097F],
    [0x00098D, 0x00098E],
    [0x000991, 0x000992],
    [0x0009B3, 0x0009B5],
    [0x0009BA, 0x0009BB],
    [0x0009C5, 0x0009C6],
    [0x0009C9, 0x0009CA],
    [0x0009CF, 0x0009D6],
    [0x0009D8, 0x0009DB],
    [0x0009E4, 0x0009E5],
    [0x0009FF, 0x001CCF],
    [0x001CD3, 0x001CD4],
    [0x001CD9, 0x001CE0],
    [0x001CE2, 0x001CE9],
    [0x001CEB, 0x001CEC],
    [0x001CEE, 0x001CF1],
    [0x001CF3, 0x001CF4],
    [0x001CF8, 0x00A8F0],
    [0x00A8F2, 0x00DBFF],
    [0x00E000, 0x10FFFF]
  ]
});
testPropertyEscapes(
  /^\P{Script_Extensions=Bengali}+$/u,
  nonMatchSymbols,
  "\\P{Script_Extensions=Bengali}"
);
testPropertyEscapes(
  /^\P{Script_Extensions=Beng}+$/u,
  nonMatchSymbols,
  "\\P{Script_Extensions=Beng}"
);
testPropertyEscapes(
  /^\P{scx=Bengali}+$/u,
  nonMatchSymbols,
  "\\P{scx=Bengali}"
);
testPropertyEscapes(
  /^\P{scx=Beng}+$/u,
  nonMatchSymbols,
  "\\P{scx=Beng}"
);

reportCompare(0, 0);
